import java.util.ArrayList;
/**
 * Beschrijft het wapenarsenaal van een personage uit een computergame.
 * 
 * @author  Dominiek Vandewalle
 * @version 2016-05-20
 */
public class Wapenarsenaal
{
    private ArrayList<Wapen> wapens;
    private Wapen actiefWapen;

    /**
     * Constructor voor objecten van de klasse Wapenarsenaal.
     */
    public Wapenarsenaal()
    {
        wapens = new ArrayList<Wapen> ();
    }
    
    /**
     * Voegt een wapen toe aan het wapenarsenaal. Het wapen wordt onmiddellijk het actief wapen.
     * param    wapen   Het nieuwe wapen.
     */
    public void wapenToevoegen(Wapen wapen)
    {
        actiefWapen = wapen;
        wapens.add(wapen);
    }
    
    /**
     * Geeft een verwijzing naar het actieve wapen terug.
     * @return  Het actieve wapen.
     */
    public Wapen getActiefWapen()
    {
        return actiefWapen;
    }
    
    /**
     * Selecteert uit het wapenarsenaal een nieuw actief wapen.
     * @param   index   De index van het te activeren wapen.
     */
    public void veranderActiefWapen(int index)
    {
        if(index >= 0 && index < wapens.size())
        {
            actiefWapen = wapens.get(index);
        }
    }
    
    /**
     * Toont informatie over alle wapens uit het wapenarsenaal in het terminalvenster.
     */
    public void print()
    {
        for(Wapen wapen: wapens)
        {
            wapen.print();
        }
    }
}
